<%@ Page Language="C#" AutoEventWireup="true" Inherits="_Default" LCID="11274" CodePage="1252" CodeBehind="default.aspx.cs" %>
<%@ OutputCache Location="None" VaryByParam="None" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
  <meta http-equiv="x-ua-compatible" content="IE=EmulateIE9" />
  <title>PECTRA Technology, Inc. - Login</title>
  <link href="Styles/main.css" rel="stylesheet" type="text/css" />
</head>
<body>
  <form id="form1" runat="server">
    <div class="Main">
      <table border="0" cellpadding="0" cellspacing="0" class="Main">
        <tr>
          <td>
            <asp:Image ID="imgLogo" runat="server" AlternateText="" ImageUrl="~/Images/LoginTopDG.jpg" /></td>
        </tr>
        <tr>
          <td class="Controls">
            <table border="0" cellpadding="0" cellspacing="0" class="Login">
              <tr>
                <td style="width: 120px;">
                  <b>
                    <asp:Label ID="lblUsername" runat="server" Text="<%$ Resources:lblUsername %>"></asp:Label></b></td>
                <td style="width: 100px;">
                  <asp:TextBox ID="txtUsername" runat="server" CssClass="TextBox" onfocus="this.select();" MaxLength="25"></asp:TextBox></td>
                <td style="width: 16px;">
                  <asp:Image ID="imgBtnBlankUserName" runat="server" AlternateText="" ImageUrl="~/Images/btnLoginBlank.jpg" CssClass="loginButtons" /></td>
                <td>
                  <asp:RequiredFieldValidator ID="valUsername" runat="server" ControlToValidate="txtUsername" Display="None" ErrorMessage="<%$ Resources:valUsername %>" SetFocusOnError="True" />
                </td>
              </tr>
              <tr>
                <td>
                  <b>
                    <asp:Label ID="lblPassword" runat="server" Text="<%$ Resources:lblPassword %>"></asp:Label></b></td>
                <td>
                  <asp:TextBox ID="txtPassword" runat="server" CssClass="TextBox" TextMode="Password" onfocus="this.select();"></asp:TextBox></td>
                <td>
                  <asp:ImageButton ID="btnLogin" runat="server" AlternateText="" ImageUrl="~/Images/btnLogin.jpg" CssClass="loginButtons" 
                      OnClick="btnLogin_Click" OnClientClick="return ValidateCaptcha();" /></td>
                <td>
                  <asp:RequiredFieldValidator ID="valPassword" runat="server" ControlToValidate="txtPassword" Display="None" ErrorMessage="<%$ Resources:valPassword %>" SetFocusOnError="True" /></td>
              </tr>
              <tr id="trDomain" runat="server" visible="false">
                <td>
                  <b>
                    <asp:Label ID="lblDomain" runat="server" Text="<%$ Resources:lblDomain %>"></asp:Label></b></td>
                <td>
                  <asp:TextBox ID="txtDomain" runat="server" CssClass="TextBox" onfocus="this.select();"></asp:TextBox></td>
                <td>
                  <asp:Image ID="imgBtnBlankDoamin" runat="server" AlternateText="" ImageUrl="~/Images/btnLoginBlank.jpg" CssClass="loginButtons" /></td>
                <td>
                  <asp:RequiredFieldValidator ID="valDomain" runat="server" ControlToValidate="txtDomain" Display="None" ErrorMessage="<%$ Resources:valDomain %>" SetFocusOnError="True" /></td>
              </tr>
              <tr id="trRemember" runat="server">
                <td colspan="4">
                  <table border="0" cellpadding="0" cellspacing="0">
                    <tr>
                      <td>
                        <asp:CheckBox ID="chkRemember" runat="server" />
                      </td>
                      <td>
                        <asp:Label ID="lblRemember" runat="server" Text="<%$ Resources:chkRemember %>"></asp:Label>
                      </td>
                    </tr>
                  </table>
                </td>
              </tr>
              <tr id="trReCaptcha" runat="server">
                  <td align="center" colspan="4">
                      <div id="ReCaptchaContainer" class="g-recaptcha"></div>   
                  </td>
              </tr>
              <tr>
                  <td colspan="4">
                      <label style="color:red;" id="lblReCaptchaMessage" runat="server" clientidmode="static"></label>
                  </td>
              </tr>
            </table>
          </td>
        </tr>
      </table>
    </div>
    <asp:ValidationSummary ID="valSummary" runat="server" HeaderText="Error:" ShowMessageBox="True" ShowSummary="False" />
    <script language="javascript" type="text/javascript">
  //<![CDATA[
  var oTxt = document.getElementById("<%=txtUsername.ClientID %>");
  oTxt.focus();
  //]]>
    </script>
  </form>
<% if (this.ShowCaptcha ) { %>
    <script type="text/javascript" src='<%= ConfigurationManager.AppSettings["SiteReCaptchaUrl"] %>?onload=renderRecaptcha&amp;render=explicit'></script>  
    <script type="text/javascript">  
        var your_site_key = '<%= ConfigurationManager.AppSettings["SiteKey"]%>';  
        var renderRecaptcha = function () {  
            grecaptcha.render('ReCaptchaContainer', {
                'sitekey': your_site_key,  
                'callback': reCaptchaCallback
            });  
        };  
      
        var reCaptchaCallback = function (response) {  
            if (response !== '') {
                document.getElementById('lblReCaptchaMessage').innerHTML = '';  
            }  
        };  
      
        function ValidateCaptcha() {
            var message = 'Por favor seleccione la casilla.';
            if (typeof (grecaptcha) != 'undefined') {
                var response = grecaptcha.getResponse();
                (response.length === 0) ? (message = 'Error en la verificacin.') : (message = '');
            }
            document.getElementById('lblReCaptchaMessage').innerHTML = message;
            if (Page_ClientValidate())
                return (message.length === 0) ? true : false;
        }
    </script>  
<% } else { %>
    <script type="text/javascript">
        function ValidateCaptcha() {
            if (Page_ClientValidate())
                return true;
        }
    </script>
<%} %>
</body>
</html>
